/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.fw.target;

import com.ibm.hwmca.fw.HException;
import com.ibm.hwmca.fw.managed.ClassId;
import com.ibm.hwmca.fw.managed.ObjectId;
import com.ibm.hwmca.fw.target.CommonTargeting;
import com.ibm.hwmca.fw.target.Target;
import com.ibm.hwmca.fw.target.TargetActionListener;
import com.ibm.hwmca.fw.target.TargetRetriever;
import com.ibm.hwmca.fw.tasklet.TaskletClientExitInterface;
import com.ibm.hwmca.fw.util.LocalizableText;
import com.ibm.hwmca.fw.util.Trace;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

public class CommonTargetingTaskletExit
implements TaskletClientExitInterface,
TargetRetriever,
Serializable {
    private static final String TRACE_MASKT = "XCMTEXTT";
    private static final String TRACE_MASKF = "XCMTEXTF";
    private static final String TRACE_MASKD = "XCMTEXTD";
    private Target[] targets = null;
    private TargetActionListener[] actions = null;
    private int type;
    private ObjectId[] selectedTargetIds = null;
    private Object targetActionListenerKey = null;
    private boolean multiSelect = false;
    private String helpInfo = null;
    private LocalizableText[] columnInfo = null;
    private LocalizableText panelTitle = null;
    private LocalizableText panelText = null;
    private transient HashMap actionMap = new HashMap();
    private int actionKey = 0;

    CommonTargetingTaskletExit(TargetRetriever retriever, String taskid, boolean multiSelect, int type, Target[] realTargets) {
        TargetActionListener[] tal;
        Trace.trace(TRACE_MASKF, "-> CommonTargetingTaskletExit.ctor");
        this.type = type;
        this.multiSelect = multiSelect;
        this.panelTitle = retriever.getPanelTitle(taskid);
        this.panelText = retriever.getPanelText(taskid);
        this.helpInfo = retriever.getPanelHelpInfo(taskid);
        this.columnInfo = retriever.getColumnHeaders(taskid);
        if (realTargets != null) {
            this.targets = new Target[realTargets.length];
            int i = 0;
            while (i < realTargets.length) {
                this.targets[i] = new Target(realTargets[i].getObjectId(), realTargets[i].getName());
                this.targets[i].setColumnData(realTargets[i].getColumnData());
                ++i;
            }
        }
        if ((tal = retriever.getActions(taskid)) != null) {
            this.actions = this.buildExitActions(tal);
        }
        Trace.trace(TRACE_MASKF, "<- CommonTargetingTaskletExit.ctor");
    }

    private TargetActionListener[] buildExitActions(TargetActionListener[] tal) {
        TargetActionListener[] actions = new ExitActionListener[tal.length];
        int i = 0;
        while (i < tal.length) {
            ++this.actionKey;
            String key = "Action" + Integer.toString(this.actionKey);
            this.actionMap.put(key, tal[i]);
            actions[i] = new ExitActionListener(tal[i], key);
            ++i;
        }
        return actions;
    }

    ObjectId[] getSelectedTargetIds() {
        return this.selectedTargetIds;
    }

    Object getTargetActionListenerKey() {
        return this.targetActionListenerKey;
    }

    Map getActionMap() {
        return this.actionMap;
    }

    public Object exit() {
        Trace.trace(TRACE_MASKF, "-> CommonTargetingTaskletExit.exit");
        Serializable returnValue = this;
        try {
            CommonTargeting ct = null;
            ct = this.type == 1 ? CommonTargeting.showTargetActionPanel(this, null, this.multiSelect, null) : CommonTargeting.showTargetSelectionPanel(this, null, this.multiSelect, null);
            Target[] selectedTargets = ct.getSelectedTargets();
            if (selectedTargets != null) {
                this.selectedTargetIds = new ObjectId[selectedTargets.length];
                int i = 0;
                while (i < selectedTargets.length) {
                    this.selectedTargetIds[i] = selectedTargets[i].getObjectId();
                    ++i;
                }
            } else {
                this.selectedTargetIds = null;
            }
            ExitActionListener action = (ExitActionListener)ct.getTargetActionListener();
            this.targetActionListenerKey = action != null ? action.getKey() : null;
        }
        catch (Exception e) {
            returnValue = new HException(e);
        }
        Trace.trace(TRACE_MASKF, "<- CommonTargetingTaskletExit.exit");
        return returnValue;
    }

    public Target[] getTargets(String taskid, Target[] target) {
        return this.targets;
    }

    public TargetActionListener[] getActions(String taskid) {
        return this.actions;
    }

    public LocalizableText getPanelTitle(String taskid) {
        return this.panelTitle;
    }

    public LocalizableText getPanelText(String taskid) {
        return this.panelText;
    }

    public String getPanelHelpInfo(String taskid) {
        return this.helpInfo;
    }

    public LocalizableText[] getColumnHeaders(String taskid) {
        return this.columnInfo;
    }

    private class ExitActionListener
    implements TargetActionListener,
    Serializable {
        private LocalizableText name = null;
        private TargetActionListener[] subActions = null;
        private ClassId[] types = null;
        private String key = null;

        public ExitActionListener(TargetActionListener realAction, String key) {
            this.key = key;
            this.name = realAction.getActionName();
            this.types = realAction.getAllowedTypes();
            TargetActionListener[] tal = realAction.getSubActions();
            if (tal != null) {
                this.subActions = CommonTargetingTaskletExit.this.buildExitActions(tal);
            }
        }

        public void performAction(Target[] target) {
            throw new UnsupportedOperationException("performAction not allowed for ExitActionListener objects");
        }

        public LocalizableText getActionName() {
            return this.name;
        }

        public TargetActionListener[] getSubActions() {
            return this.subActions;
        }

        public ClassId[] getAllowedTypes() {
            return this.types;
        }

        public String getKey() {
            return this.key;
        }
    }
}

